#include <Servo.h>
//#include <FastLED.h>
#include <Adafruit_NeoPixel.h>

#define LEFT_A 3
#define LEFT_B 2
#define RIGHT_A 5
#define RIGHT_B 4
#define LED_PIN 13
#define LEFT_EYE 0
#define RIGHT_EYE 1
#define SERVO_PIN 12
#define MOTOR_MAX 255
#define MOTOR_HIGH 204
#define MOTOR_MIDDLE 167
#define MOTOR_LOW 128
#define MOTOR_ZERO 0
#define WAIT 20

Servo sg90;
Adafruit_NeoPixel pixels = Adafruit_NeoPixel(2, LED_PIN, NEO_RGB);

void turn_servo(int step, int s_angle, int e_angle) {
  int i, angle;

  for (i = 0; i < step; i++) {
    angle = s_angle + (e_angle - s_angle) * i / step;
    sg90.write(angle);
    delay(WAIT);
  }
}

void setup() {
  // put your setup code here, to run once:
  Serial.begin(115200);
  pinMode(LEFT_A, OUTPUT);
  pinMode(LEFT_B, OUTPUT);
  pinMode(RIGHT_A, OUTPUT);
  pinMode(RIGHT_B, OUTPUT);
  sg90.attach(SERVO_PIN);
  delay(100);
  sg90.write(90);
  pixels.begin();
  pixels.setPixelColor(LEFT_EYE, pixels.Color(0, 0, 0));
  pixels.setPixelColor(RIGHT_EYE, pixels.Color(0, 0, 0));
  pixels.show();
  delay(500);
}

void loop() {
  int i, j, k, hl, lr, lg, lb, s_angle, e_angle;

  for (i = 0; i < 2; i++) {
    for (j = 0; j < 2; j++) {
      hl = (i == 0) ? (j == 0) ? HIGH : LOW
                    : (j == 0) ? LOW : HIGH;
      lr = 255;
      lg = (i == 0) ? (j == 0) ? 0 : 255
                    : (j == 0) ? 255 : 0;
      lb = (i == 0) ? (j == 0) ? 0 : 255
                    : (j == 0) ? 255 : 0;
      digitalWrite(LEFT_B, hl);
      digitalWrite(RIGHT_B, hl);
      for (k = 0; k < 3; k++) {
        s_angle = (i == 0) ? (j == 0) ? 90 - k * 15 : 90 + k * 15
                           : (j == 0) ? 90 + k * 15 : 90 - k * 15;
        e_angle = (i == 0) ? (j == 0) ? s_angle - 15 : s_angle + 15
                           : (j == 0) ? s_angle + 15 : s_angle - 15;
        pixels.setPixelColor(LEFT_EYE, pixels.Color(lr, lg, lb));
        pixels.setPixelColor(RIGHT_EYE, pixels.Color(lr, lb, lb));
        pixels.show();
        analogWrite(LEFT_A, MOTOR_MAX);
        analogWrite(RIGHT_A, MOTOR_MAX);
        turn_servo(10, s_angle, e_angle);  
        pixels.setPixelColor(LEFT_EYE, pixels.Color(0, 0, 0));
        pixels.setPixelColor(RIGHT_EYE, pixels.Color(0, 0, 0));
        pixels.show();
        analogWrite(LEFT_A, MOTOR_ZERO);
        analogWrite(RIGHT_A, MOTOR_ZERO);
        delay(WAIT * 10);  
      }
      s_angle = (i == 0) ? (j == 0) ? 45 : 135
                         : (j == 0) ? 135 : 45;
      turn_servo(10, s_angle, 90);  
      delay(WAIT * 10);
    }

    for (k = 0; k < 7; k++) {
      hl = (i == 0) ? (k < 4) ? HIGH : LOW
                    : (k < 4) ? LOW : HIGH;
      lr = 255;
      lg = (i == 0) ? (k < 4) ? 0 : 255
                    : (k < 4) ? 255 : 0;
      lb = (i == 0) ? (k < 4) ? 0 : 255
                    : (k < 4) ? 255 : 0;
      if (k < 3) {
        s_angle = (i == 0) ? 90 - k * 15 : 90 + k * 15;
        e_angle = (i == 0) ? s_angle - 15 : s_angle + 15;
      }
      else if (k == 3) {
        s_angle = (i == 0) ? 45 : 135;
        e_angle = 90;
      }
      else if (k > 3) {
        s_angle = (i == 0) ? 90 + (k - 4) * 15 : 90 - (k - 4) * 15;
        e_angle = (i == 0) ? s_angle + 15 : s_angle - 15;
      }
      digitalWrite(LEFT_B, hl);
      digitalWrite(RIGHT_B, hl);
      pixels.setPixelColor(LEFT_EYE, pixels.Color(lr, lg, lb));
      pixels.setPixelColor(RIGHT_EYE, pixels.Color(lr, lb, lb));
      pixels.show();
      analogWrite(LEFT_A, MOTOR_MAX);
      analogWrite(RIGHT_A, MOTOR_MAX);
      turn_servo(10, s_angle, e_angle);  
      pixels.setPixelColor(LEFT_EYE, pixels.Color(0, 0, 0));
      pixels.setPixelColor(RIGHT_EYE, pixels.Color(0, 0, 0));
      pixels.show();
      analogWrite(LEFT_A, MOTOR_ZERO);
      analogWrite(RIGHT_A, MOTOR_ZERO);
      delay(WAIT * 10);  
    }
    s_angle = (i == 0) ? 135 : 45;
    turn_servo(10, s_angle, 90);  
    delay(WAIT * 10);  
  }

  digitalWrite(LEFT_B, HIGH);
  digitalWrite(RIGHT_B, LOW);
  analogWrite(LEFT_A, MOTOR_MAX);
  analogWrite(RIGHT_A, MOTOR_MAX);
  for (k = 0; k < 8; k++) {
    Serial.print("k = ");
    Serial.println(k);
    if (k == 7) {
      analogWrite(LEFT_A, MOTOR_ZERO);
      analogWrite(RIGHT_A, MOTOR_ZERO);
    }
    if (k == 7) {
      pixels.setPixelColor(LEFT_EYE, pixels.Color(0, 0, 0));
      pixels.setPixelColor(RIGHT_EYE, pixels.Color(0, 0, 0));
    }
    else if (k % 2 == 0) {
      pixels.setPixelColor(LEFT_EYE, pixels.Color(255, 0, 0));
      pixels.setPixelColor(RIGHT_EYE, pixels.Color(255, 255, 255));
    }
    else if (k % 2 == 1) {
      pixels.setPixelColor(LEFT_EYE, pixels.Color(255, 255, 255));
      pixels.setPixelColor(RIGHT_EYE, pixels.Color(255, 0, 0));
    }
    pixels.show();
/*
    s_angle = (k % 2) == 0 ? 90 :
              (k % 4) == 1 ? 60 : 90;
    e_angle = (k % 2) == 1 ? 90 :
              (k % 4) == 0 ? 60 : 120;
*/              
    if (k % 4 == 0) {
      s_angle = 90;
      e_angle = 60;
    }
    else if (k % 4 == 1) {
      s_angle = 60;
      e_angle = 90;
    }
    else if (k % 4 == 2) {
      s_angle = 90;
      e_angle = 120;
    }
    else if (k % 4 == 3) {
      s_angle = 120;
      e_angle = 90;
    }
    turn_servo(20, s_angle, e_angle);
  }

  digitalWrite(LEFT_B, HIGH);
  digitalWrite(RIGHT_B, HIGH);
  analogWrite(LEFT_A, MOTOR_MAX);
  analogWrite(RIGHT_A, MOTOR_MAX);
  pixels.setPixelColor(LEFT_EYE, pixels.Color(255, 255, 255));
  pixels.setPixelColor(RIGHT_EYE, pixels.Color(255, 255, 255));
  pixels.show();
  delay(WAIT * 10);
  analogWrite(LEFT_A, MOTOR_ZERO);
  analogWrite(RIGHT_A, MOTOR_ZERO);
  pixels.setPixelColor(LEFT_EYE, pixels.Color(0, 0, 0));
  pixels.setPixelColor(RIGHT_EYE, pixels.Color(0, 0, 0));
  pixels.show();
  delay(WAIT * 150);
}
