<?php
/*
Plugin Name: Valid YouTube Shortcode
Plugin URI: http://www.h-fj.com/blog/wpplgdoc/youtube_shortcode.php
Description: YouTubeのショートコードを追加します。
Version: 1.01
Author: 藤本　壱
Author URI: http://www.h-fj.com/blog/
*/

function youtube_shortcode($atts) {
    // 属性を取り出す
    extract(shortcode_atts(array(
        'id' => 'RyHlRbKyZ-g',
        'width' => 445,
        'height' => 364,
        'rwidth' => 0,
    ), $atts));
    // id／width／heightの属性が指定されているときだけ処理する
    if ($id && $width && $height) {
        // rwidth属性が指定されていたら、高さを計算し直す
        if ($rwidth) {
            $rate = $rwidth / $width;
            $width = $rwidth;
            $height = intval($height * $rate);
        }
        // iPhone / iPod Touch / iPad対応
        $ua = $_SERVER['HTTP_USER_AGENT'];
        $html = '';
        if (preg_match('/iPad/', $ua)) {
            $html = <<< HERE
<embed width="$width" height="$height" wmode="transparent" type="application/x-shockwave-flash" src="http://www.youtube.com/v/$id" />
HERE;
        }
        else if (preg_match('/(iPhone|iPod)/', $ua)) {
            $html = <<< HERE
<embed width="120" height="72" wmode="transparent" type="application/x-shockwave-flash" src="http://www.youtube.com/v/$id" />
HERE;
        }
        // XHTML(iPhone / iPod Touch / iPadを除く)のコードを生成する
        if (!$html) {
            $html = <<< HERE
<div>
<object data="http://www.youtube.com/v/$id" type="application/x-shockwave-flash" width="$width" height="$height"><param name="movie" value="http://www.youtube.com/v/$id" /><param name="wmode" value="transparent" /></object>
</div>
HERE;
        }
        return $html;
    }
    else {
        return '';
    }
}

// ショートコードを登録する
add_shortcode('youtube', 'youtube_shortcode');
?>
